/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.data.tcon.material;

import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IMaterialRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.IRecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import tcintegrations.common.TagManager;
import tcintegrations.data.integration.ModIntegration;
import tcintegrations.data.tcon.material.MaterialIds;
import tcintegrations.items.TCIntegrationsItems;
import vazkii.botania.common.block.ModBlocks;

public class MaterialRecipeProvider
extends RecipeProvider
implements IConditionBuilder,
IRecipeHelper,
IMaterialRecipeHelper {
    public MaterialRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    public String m_6055_() {
        return "TCIntegrations - TCon Material Recipe";
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        this.addMaterialItems(consumer);
        this.addMaterialSmeltery(consumer);
    }

    public String getModId() {
        return "tcintegrations";
    }

    private void addMaterialItems(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/materials/";
        Consumer botaniaConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("botania")});
        Consumer aquacultureConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("aquaculture")});
        Consumer malumConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("malum")});
        Consumer beyondEarthConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("beyond_earth")});
        Consumer brassConsumer = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/brass")});
        Consumer bygConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("byg")});
        this.materialRecipe(botaniaConsumer, (MaterialVariantId)MaterialIds.livingWood, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.BOTANIA_LIVINGWOOD_PLANKS}), 1, 1, folder + "livingwood/planks");
        this.materialRecipe(botaniaConsumer, (MaterialVariantId)MaterialIds.livingWood, Ingredient.m_204132_(TagManager.Items.BOTANIA_LIVINGWOOD_LOGS), 4, 1, ItemOutput.fromStack((ItemStack)new ItemStack((ItemLike)ModIntegration.BOTANIA_LIVINGWOOD_PLANKS)), folder + "livingwood/logs");
        this.materialRecipe(botaniaConsumer, (MaterialVariantId)MaterialIds.livingRock, Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModBlocks.livingrock)}), 1, 1, folder + "livingrock");
        this.metalMaterialRecipe(botaniaConsumer, (MaterialVariantId)MaterialIds.manaSteel, folder, "manasteel", true);
        this.metalMaterialRecipe(aquacultureConsumer, (MaterialVariantId)MaterialIds.neptunium, folder, "neptunium", true);
        this.metalMaterialRecipe(malumConsumer, (MaterialVariantId)MaterialIds.soulStainedSteel, folder, "soul_stained_steel", true);
        this.metalMaterialRecipe(beyondEarthConsumer, (MaterialVariantId)MaterialIds.desh, folder, "desh", true);
        this.metalMaterialRecipe(beyondEarthConsumer, (MaterialVariantId)MaterialIds.calorite, folder, "calorite", true);
        this.metalMaterialRecipe(beyondEarthConsumer, (MaterialVariantId)MaterialIds.ostrum, folder, "ostrum", true);
        this.metalMaterialRecipe(brassConsumer, (MaterialVariantId)slimeknights.tconstruct.tools.data.material.MaterialIds.brass, folder, "brass", true);
        this.metalMaterialRecipe(bygConsumer, (MaterialVariantId)MaterialIds.pendoriteAlloy, folder, "pendorite_alloy", true);
    }

    private void addMaterialSmeltery(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/materials/";
        this.compatMeltingCasting(consumer, slimeknights.tconstruct.tools.data.material.MaterialIds.brass, TinkerFluids.moltenBrass, folder);
        this.compatMeltingCasting(consumer, MaterialIds.manaSteel, TCIntegrationsItems.MOLTEN_MANASTEEL, folder);
        this.compatMeltingCasting(consumer, MaterialIds.neptunium, TCIntegrationsItems.MOLTEN_NEPTUNIUM, folder);
        this.compatMeltingCasting(consumer, MaterialIds.soulStainedSteel, TCIntegrationsItems.MOLTEN_SOUL_STAINED_STEEL, folder);
        this.compatMeltingCasting(consumer, MaterialIds.desh, ModIntegration.MOLTEN_DESH, folder);
        this.compatMeltingCasting(consumer, MaterialIds.calorite, ModIntegration.MOLTEN_CALORITE, folder);
        this.compatMeltingCasting(consumer, MaterialIds.ostrum, ModIntegration.MOLTEN_OSTRUM, folder);
        this.compatMeltingCasting(consumer, MaterialIds.pendoriteAlloy, TCIntegrationsItems.MOLTEN_PENDORITE_ALLOY, folder);
    }
}

